%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% reportsascm.cls
% Estil per a la revista reports@scm
% Versió 19.03.25
%

\LoadClass[11pt,twoside]{article}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{reportsascm}[2023/09/28 Estil de la revista reportsascm]
\RequirePackage{xcolor}
\RequirePackage{graphicx}
\RequirePackage{hyperref}
\hypersetup{citecolor=blue}
\hypersetup{urlcolor=gris}
\RequirePackage{lastpage}
\RequirePackage{sfmath}
\definecolor{blau}{RGB}{43,129,173}
\definecolor{gris}{RGB}{100,100,100}
%Marges
\usepackage[a4paper,left=20mm,top=18mm,right=20mm,bottom=25mm,includeheadfoot,headheight=24mm, headsep=0mm, footskip=15mm]{geometry}
\makeatletter
%Parametres de la pagina
\hypersetup{colorlinks=true,urlcolor=black}
%Definim les variables numero, any, pagin, pagfin, doi, ...
\def\l@any{????}
\def\l@numero{??}
\def\l@pagin{1}
\def\l@pagfin{\pageref*{LastPage}}
\def\l@doi{???????????}
\def\l@abstractceng{No abstract}
\def\l@abstractcat{Sense abstract}
\def\@paraulesclau{}
\def\@nymsc{2020}
\def\@msc{}
\def\@rebut{\today}
\def\@acceptat{\today}
\newcommand{\any}[1]{\def\l@any{#1}}
\newcommand{\numero}[1]{\def\l@numero{#1}}
\newcommand{\pagin}[1]{\def\l@pagin{#1}\setcounter{page}{#1}}
\newcommand{\pagfin}[1]{\def\l@pagfin{#1}}
\newcommand{\doi}[1]{\def\l@doi{#1}}
\newcommand{\abstracteng}[1]{\def\l@abstracteng{#1}}
\newcommand{\abstractcat}[1]{\def\l@abstractcat{#1}}
\newcommand{\paraulesclau}[1]{\def\@paraulesclau{#1}}
\newcommand{\msc}[2][2020]{\def\@nymsc{#1}\def\@msc{#2}}
\newcommand{\rebut}[1]{\def\@rebut{#1}}
\newcommand{\acceptat}[1]{\def\@acceptat{#1}}
%Modifiquem el títol i fem la portada
\newcommand{\titol}[1]{\title{#1}\def\@ltitle{#1}}
\def\@ltitleshort{\@ltitle}
\newcommand{\titolcurt}[1]{\def\@ltitleshort{#1}}
\def\s@lt{\vskip 2mm plus 2mm}
\def\s@ltet{\vskip 1mm plus 1mm}
\def\@maketitle{%
\thispagestyle{empty}
\noindent
\setlength{\unitlength}{1mm}%
\begin{picture}(0,0)
\put(75,-30){\begin{tabular}{c}AN ELECTRONIC JOURNAL OF THE\\SOCIETAT CATALANA DE MATEM\`ATIQUES\end{tabular}}
\put(-15,-90){\begin{minipage}[t]{55mm}
\setcounter{i@autor}{1}%
\flushright
\loop
{\hfill \bf\csname @pautor\thei@autor\endcsname}\\\s@ltet
{\color{gris}\csname l@univautor\thei@autor\endcsname}\\
{\color{gris}\csname l@emailautor\thei@autor\endcsname}\\\s@lt
\ifnum \c@i@autor < \c@num@utors \addtocounter{i@autor}{1} 
\repeat
$\ast${\small Corresponding author}
\end{minipage}}

\put(49,-90){\begin{minipage}[t]{121mm}
{\bf Resum} {\color{gris}\it (CAT)}\\%\s@ltet
{\small \l@abstractcat}\\\s@lt
{\bf Abstract} {\color{gris}\it (ENG)}\\%\s@ltet
{\small \l@abstracteng}
\end{minipage}
}

\put(49,-183){\begin{minipage}[t]{121mm}
{\it\bf Keywords:} {\it\color{gris} \@paraulesclau}\\
{\it\bf MSC (\@nymsc):} {\it\color{gris} \@msc}
\end{minipage}}
\put(49,-200){\begin{minipage}[t]{121mm}
{\it\bf Received:} {\it\color{gris} \@rebut}\\
{\it\bf Accepted:} {\it\color{gris} \@acceptat}
\end{minipage}}

\put(150,-228){\makebox[20mm][r]{\it\thepage}}
\put(35,-228){\makebox[90mm][r]{{\small\color{gris} Reports@SCM \textbf{\l@numero}\ (\l@any),\ \l@pagin--\l@pagfin;\ DOI:\l@doi.}}}
\end{picture}
\vskip 5cm
\begin{center}
{\color{blau}\Huge\bf\@title}
\end{center}
}
\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{empty}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \newpage
}

% Guardem els autors a les variables
\newcounter{num@utors}\setcounter{num@utors}{0}
\newcommand{\autor}[1]{\author{#1}\addtocounter{num@utors}{1}\expandafter\def\csname @lautor\thenum@utors\endcsname{#1}\expandafter\def\csname @pautor\thenum@utors\endcsname{#1}}
\newcommand{\corrautor}[1]{\author{#1}\addtocounter{num@utors}{1}\expandafter\def\csname @lautor\thenum@utors\endcsname{#1}\expandafter\def\csname @pautor\thenum@utors\endcsname{${}^\ast$#1}}
\newcommand{\univautor}[1]{\expandafter\def\csname l@univautor\thenum@utors\endcsname{#1}}
\newcommand{\emailautor}[1]{\expandafter\def\csname l@emailautor\thenum@utors\endcsname{#1}}
% Fem la caixa que apareixerà  a les capçaleres
\newcounter{i@autor}
\newcommand{\autorsbox}{\setcounter{i@autor}{1}%
\loop
\bf\it\csname @lautor\thei@autor\endcsname 
\ifnum \c@i@autor < \c@num@utors , \addtocounter{i@autor}{1} 
\repeat
}

%Modifiquem les capçaleres i els peus
\RequirePackage{fancyhdr}
\newcommand{\titlebox}{\makebox[170mm][r]{\@title}}
\renewcommand{\headrulewidth}{0pt}
\pagestyle{fancy}
\fancyhf{}
\fancyhead[RO]{\setlength{\unitlength}{1mm}%
\begin{picture}(0,0)
\put(-170,10){\autorsbox}
\end{picture}}
\fancyhead[RE]{\setlength{\unitlength}{1mm}%
\begin{picture}(0,0)
\put(-170,10){\makebox[170mm][r]{\@ltitleshort}}
\end{picture}}
\fancyfoot[RO]{\setlength{\unitlength}{1mm}%
\begin{picture}(0,0)
\put(-20,-3){\makebox[20mm][r]{\it\thepage}}
\put(-130,-3){\makebox[90mm][r]{\color{gris} {\small Reports@SCM \textbf{\l@numero}\ (\l@any),\ \l@pagin--\l@pagfin;\ DOI:\l@doi.}}}
\end{picture}}
\fancyfoot[RE]{\setlength{\unitlength}{1mm}%
\begin{picture}(0,0)
\put(-100,-3){\href{https://revistes.iec.cat/index.php/reports}{\small{{\tt {\it https://revistes.iec.cat/index.php/reports}}}}}
\put(-170,-3){\makebox[20mm][l]{\it\thepage}}
\end{picture}}
%Seccions i altres
\RequirePackage{titlesec}
\titleformat{\section}
          {\color{blau}\normalfont\huge\bfseries} 
          {\thesection.}
          {1ex \@plus.2ex}
          {}
\titleformat{\subsection}
          {\normalfont\Large\bfseries} 
          {\Large\thesubsection}
          {1ex \@plus.2ex}
          {}
\titleformat{\subsubsection}
          {\normalfont\large\bfseries} 
          {\huge\thesubsection}
          {1ex \@plus.2ex}
          {}
\titleformat{\paragraf}
          {\normalfont\normalsize\bfseries} 
          {\huge\thesubsection}
          {1ex \@plus.2ex}
          {}
\titleformat{\subparagraf}
          {\normalfont\normalsize\bfseries} 
          {\huge\thesubsection}
          {1ex \@plus.2ex}
          {}

% No té indentació i té separació entre paràgrafs
\setlength{\parskip}{1mm}
% Modifiquem les fonts
\renewcommand*{\familydefault}{\sfdefault}
%Agraïments abans de la bibliografia
\newcommand{\agraiments}[1]{\addvspace{5ex}\subsection*{\color{blau} Acknowledgements} #1} 
% Modifiquem la bibliografia
\usepackage{multicol}
\usepackage{etoolbox}
\patchcmd{\thebibliography}{\section*{\refname}}
    {\begin{multicols}{2}[\section*{\refname}]}{}{}
\patchcmd{\endthebibliography}{\endlist}{\endlist\end{multicols}}{}{}
\makeatother
